
local PICKUP = {
	SNIPER_HIGH_DAMAGE = 6,
	SHOTGUN_HIGH_CAPACITY = 4,
	AR_HIGH_CAPACITY = 2,
	OTHER = 1,
	SNIPER_LOW_DAMAGE = 5,
	AR_MED_CAPACITY = 3,
}

function WeaponTweakData:_pickup_chance(max_ammo, selection_index)
	local low, high = nil

	if selection_index == PICKUP.AR_HIGH_CAPACITY then
		low = 0.03
		high = 0.055
	elseif selection_index == PICKUP.AR_MED_CAPACITY then
		low = 0.03
		high = 0.055
	elseif selection_index == PICKUP.SHOTGUN_HIGH_CAPACITY then
		low = 0.05
		high = 0.075
	elseif selection_index == PICKUP.SNIPER_LOW_DAMAGE then
		low = 0.05
		high = 0.075
	elseif selection_index == PICKUP.SNIPER_HIGH_DAMAGE then
		low = 0.005
		high = 0.015
	else
		low = 0.01
		high = 0.035
	end

	return {
		max_ammo * low,
		max_ammo * high
	}
end

local old_init = WeaponTweakData.init

function WeaponTweakData:init(tweak_data)
    old_init(self, tweak_data)
	

	self.x_mp5.AMMO_PICKUP = self:_pickup_chance(self.x_mp5.AMMO_MAX, PICKUP.AR_HIGH_CAPACITY)
	self.x_sr2.AMMO_PICKUP = self:_pickup_chance(self.x_sr2.AMMO_MAX, PICKUP.AR_HIGH_CAPACITY)
	self.x_mac10.AMMO_PICKUP = self:_pickup_chance(self.x_mac10.AMMO_MAX, PICKUP.AR_HIGH_CAPACITY)
	self.x_mp9.AMMO_PICKUP = self:_pickup_chance(self.x_mp9.AMMO_MAX, PICKUP.AR_HIGH_CAPACITY)
	self.x_olympic.AMMO_PICKUP = self:_pickup_chance(self.x_olympic.AMMO_MAX, PICKUP.AR_HIGH_CAPACITY)
	self.x_p90.AMMO_PICKUP = self:_pickup_chance(self.x_p90.AMMO_MAX, PICKUP.AR_HIGH_CAPACITY)
	self.x_mp7.AMMO_PICKUP = self:_pickup_chance(self.x_mp7.AMMO_MAX, PICKUP.AR_HIGH_CAPACITY)
	self.x_scorpion.AMMO_PICKUP = self:_pickup_chance(self.x_scorpion.AMMO_MAX, PICKUP.AR_HIGH_CAPACITY)
	self.x_baka.AMMO_PICKUP = self:_pickup_chance(self.x_baka.AMMO_MAX, PICKUP.AR_HIGH_CAPACITY)
	self.x_tec9.AMMO_PICKUP = self:_pickup_chance(self.x_tec9.AMMO_MAX, PICKUP.AR_HIGH_CAPACITY)
	self.x_polymer.AMMO_PICKUP = self:_pickup_chance(self.x_polymer.AMMO_MAX, PICKUP.AR_HIGH_CAPACITY)
	self.x_sterling.AMMO_PICKUP = self:_pickup_chance(self.x_sterling.AMMO_MAX, PICKUP.AR_HIGH_CAPACITY)
	self.x_uzi.AMMO_PICKUP = self:_pickup_chance(self.x_uzi.AMMO_MAX, PICKUP.AR_HIGH_CAPACITY)
	self.x_m1928.AMMO_PICKUP = self:_pickup_chance(self.x_m1928.AMMO_MAX, PICKUP.AR_HIGH_CAPACITY)
	self.x_cobray.AMMO_PICKUP = self:_pickup_chance(self.x_cobray.AMMO_MAX, PICKUP.AR_HIGH_CAPACITY)
	
	--joy's guns
	self.x_shepheard.AMMO_PICKUP = self:_pickup_chance(self.x_shepheard.AMMO_MAX, PICKUP.AR_HIGH_CAPACITY)
	self.shepheard.AMMO_PICKUP = self:_pickup_chance(self.shepheard.AMMO_MAX, PICKUP.AR_HIGH_CAPACITY)
	end
	